//
//  YFRaiseLight.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 抬腕亮屏
public class YFRaiseLight: YFModelBase {
    /// 开关
    public var onoff: YFCmdSwitchType = .on
    /// 开始小时
    public var startHour: UInt8 = 8
    /// 开始分钟
    public var startMin: UInt8 = 0
    /// 结束小时
    public var endHour: UInt8 = 22
    /// 结束分钟
    public var endMin: UInt8 = 0
    
    
    var cmd: YD_SyncUpBrightCmd {
        let cmd = YD_SyncUpBrightCmd()
        cmd.onoff = onoff.rawValue
        cmd.start_hour = startHour
        cmd.start_min = startMin
        cmd.end_hour = endHour
        cmd.end_min = endMin
        return cmd
    }
}

extension YFRaiseLight {
    func csvContent() -> String {
        let data = [onoff.rawValue, startHour, startMin, endHour, endMin]
        let titleItems = ["Raise light screen,On/Off", ",Start hour", ",Start minute", ",End hour", ",End minute"]
        let valueItems: [String] = data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
