//
//  YFRemindDrink.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 免打扰时间项
public class YFRemindDrink: YFModelBase {
    /// 开关
    public var isOpen: YFCmdSwitchType = .on
    /// 提醒间隔
    public var interval: UInt8 = 0

    /// 开始小时
    public var startHour: UInt8 = 8
    /// 开始分钟
    public var startMin: UInt8 = 0
    /// 结束小时
    public var endHour: UInt8 = 22
    /// 结束分钟
    public var endMin: UInt8 = 59
    
    var cmd: YD_SyncDrinkAlarmCmd {
        let cmd = YD_SyncDrinkAlarmCmd()
        cmd.onoff = isOpen.rawValue

        cmd.interval = interval
        cmd.start_hour = startHour
        cmd.start_min = startMin
        cmd.end_hour = endHour
        cmd.end_min = endMin
        return cmd
    }
}

extension YFRemindDrink {
    func csvContent() -> String {
        let data = [isOpen.rawValue, startHour, startMin, endHour, endMin,  interval]
        let titleItems = ["Drink water reminder,On/Off", ",Start hour", ",Start minute", ",End hour", ",End minute", ",Interval"]
        let valueItems: [String] = data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
