//
//  YFRemindNotifySwitch.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 通知提醒
public class YFRemindNotifySwitch: YFModelProtocol {
    /// 总开关
    public var allSwitch: YFCmdSwitchType = .on
    /// Other
    public var other: YFCmdSwitchType = .on

    /// WeChat
    public var wechat: YFCmdSwitchType = .on
    /// qq
    public var qq: YFCmdSwitchType = .on
    /// 邮箱
    public var email: YFCmdSwitchType = .on
    
    /// Facebook
    public var facebook: YFCmdSwitchType = .on
    /// Instagram
    public var instagram: YFCmdSwitchType = .on
    /// Twitter
    public var twitter: YFCmdSwitchType = .on
    /// WhatsApp
    public var whatsapp: YFCmdSwitchType = .on
    /// Skype
    public var skype: YFCmdSwitchType = .on

    /// Line
    public var line: YFCmdSwitchType = .on
    /// linkedIn
    public var linkedIn: YFCmdSwitchType = .on

    

    // MARK: - Initialize
    required public init() {}
    
    var cmd: CE_SyncWatchMenuCmd {
        let cmd = CE_SyncWatchMenuCmd()
        cmd.allSwitch = allSwitch.boolValue
        cmd.other = qq.boolValue

        cmd.qq = qq.boolValue
        cmd.wechat = wechat.boolValue
        cmd.email = email.boolValue
        
        cmd.facebook = facebook.boolValue
        cmd.twitter = twitter.boolValue
        cmd.whatsapp = whatsapp.boolValue
        cmd.instagram = instagram.boolValue
        cmd.skype = skype.boolValue
        cmd.line = line.boolValue
        cmd.linkedIn = linkedIn.boolValue
        return cmd
    }
    
}
