//
//  YFRemindRaiseLight.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 抬腕亮屏
public class YFRemindRaiseLight: YFModelProtocol {
    /// 开关
    public var onoff: YFCmdSwitchType = .on
    /// 开始小时
    public var startHour: UInt8 = 8
    /// 开始分钟
    public var startMin: UInt8 = 0
    /// 结束小时
    public var endHour: UInt8 = 22
    /// 结束分钟
    public var endMin: UInt8 = 0
    
    // MARK: - Initialize
    required public init() {}
    
    var cmd: YD_SyncUpBrightCmd {
        let cmd = YD_SyncUpBrightCmd()
        cmd.onoff = onoff.rawValue
        cmd.start_hour = startHour
        cmd.start_min = startMin
        cmd.end_hour = endHour
        cmd.end_min = endMin
        return cmd
    }
}
