//
//  YFRemindSedentary.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 久坐提醒
public class YFRemindSedentary: YFModelBase {
    /// 午休开关
    public var noon_onoff: YFCmdSwitchType = .on
    /// 开关
    public var isOpen: YFCmdSwitchType = .off
    /// 周重复 （掩码方式: 低7位）
    public var week_repeat: UInt8 = 0x7F

    /// 开始小时
    public var startHour: UInt8 = 10
    /// 开始分钟
    public var startMin: UInt8 = 0
    /// 结束小时
    public var endHour: UInt8 = 22
    /// 结束分钟
    public var endMin: UInt8 = 0
        
    var cmd: CE_SyncLongSitRemindCmd {
        let cmd = CE_SyncLongSitRemindCmd()
        cmd.noon_onoff = noon_onoff.rawValue
        cmd.flag = isOpen.rawValue

        cmd.week_repeat = week_repeat
        cmd.startTimeHour = startHour
        cmd.startTimemin = startMin
        cmd.endTimeHour = endHour
        cmd.endTimeMin = endMin
        return cmd
    }
}

extension YFRemindSedentary {
    func csvContent() -> String {
        let data = [isOpen.rawValue, startHour, startMin, endHour, endMin, noon_onoff.rawValue, week_repeat]
        let titleItems = ["Sedentary reminder,On/Off", ",Start hour", ",Start minute", ",End hour", ",End minute", ",Noon On/Off", ",Repeat"]
        let valueItems: [String] = data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
