//
//  YFHourly.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

public enum YFHourlyType: UInt8, YFEnumtProtocol{
    case h12 = 0x00
    case h24
}

/// 时间制
public class YFHourly: YFModelBase {

    public var format: YFHourlyType = .h24
    
    var cmd: CE_SyncTimeCmd {
        let cmd = CE_SyncTimeCmd()
        cmd.absTime = UInt32(truncating: NSNumber(value: YFCalendarUtils.nowTimeinterval))
        cmd.offsetTime = Int32(truncating: NSNumber(value: YFCalendarUtils.timeZoneTimeinterval))
        cmd.format = format.rawValue
        return cmd
    }
        
}

extension YFHourly {
    func csvContent() -> String {
        let content = "Hourly" + ",\(format.rawValue)" + "\n"
        return content
    }
}
