//
//  YFLanguage.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/**
 语言类型 0：英语, 1: 中文, 2: Spanish(西班牙),
        3: Italian(意大利),  4: Portuguese(葡萄牙),
        5: French(法语)
 */
/// 设备中对应的语言代码值
public enum YFLanType: UInt8, YFEnumtProtocol {
    case en = 0
    case zh
    case es
    case it
    case pt
    case fr
    case de

    var value: UInt8 {
        switch self {
        case .en: return 0
        case .zh: return 1
        case .es: return 2
        case .it: return 3
        case .pt: return 4
        case .fr: return 5
        case .de: return 1
        }
    }

    var prefixIdentify: String {
        switch self {
        case .en: return "en"
        case .zh: return "zh"
        case .es: return "es"
        case .it: return "it"
        case .pt: return "pt"
        case .fr: return "fr"
        case .de: return "de"
        }
    }
    
    static var collection_normal: [YFLanType]  = [.en, .zh, .es, .it, .pt, .fr]
    
    static var collection_sw294: [YFLanType]  = [.en, .de, .es, .it, .pt, .fr]

    
    public static var app: YFLanType {
        guard let identify = Locale.preferredLanguages.first else { return.en }
        var type: YFLanType = .en
        if YFKitService.isSW294 {
            for e in collection_sw294 { if identify.hasPrefix(e.prefixIdentify) { type = e; break } }
        } else {
            for e in collection_normal { if identify.hasPrefix(e.prefixIdentify) { type = e; break } }
        }
        return type
    }
}

extension YFLanType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .en: return "英文"
        case .zh: return "中文"
        case .es: return "西班牙文"
        case .it: return "意大利文"
        case .pt: return "葡萄牙文"
        case .fr: return "法文"
        case .de: return "德文"
        }
    }
}

/// 语言
public class YFLanguage: YFModelBase {

    public var type: YFLanType = .en
    
    var cmd: YD_SyncLanguageCmd {
        let cmd = YD_SyncLanguageCmd()
        cmd.language = type.value
        return cmd
    }
}

extension YFLanguage {
    func csvContent() -> String {
        let content = "Language" + "," + "\(type.value)" + "\n"
        return content
    }
}
