//
//  YFUnit.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

public enum YFGenderType: UInt8, YFEnumtProtocol {
    case male = 0x00
    case female
}

extension YFGenderType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .male: return "male"
        case .female: return "female"
        }
    }
}

public enum YFHandType: UInt8, YFEnumtProtocol {
    case left = 0x00
    case right
}

extension YFHandType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .left: return "left"
        case .right: return "right"
        }
    }
}

///: - 公英制
public enum YFSystemType: UInt8, YFEnumtProtocol {
    case metric = 0x00
    case imperial
}

extension YFSystemType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .metric: return "metric"
        case .imperial: return "imperial"
        }
    }
}

/// 距离单位 0: 米，1：英里
public enum YFDistanceType: UInt8, YFEnumtProtocol {
    case m     = 0x00
    case mile
}

extension YFDistanceType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .m: return "m"
        case .mile: return "mile"
        }
    }
}

/// 重量单位 0: 千克，1：磅，2：英石
public enum YFWeightUnitsType: UInt8, YFEnumtProtocol {
    case kg = 0x00
    case lb
    case st
}

extension YFWeightUnitsType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .kg: return "kg"
        case .lb: return "lb"
        case .st: return "st"
        }
    }
}

/// 温度单位 0: 摄氏度，1：华氏度
public enum YFTempUnitsType: UInt8, YFEnumtProtocol {
    case centigrade = 0x00
    case fahrenheit
}

extension YFTempUnitsType: CustomStringConvertible {
    public var description: String {
        switch self {
        case .centigrade: return "Centigrade"
        case .fahrenheit: return "Fahrenheit"
        }
    }
}


/// 单位（公英制）
public class YFUnit: YFModelBase {
    /// 距离 m、mile
    var distance: YFDistanceType = .m
    /// 体重 kg、lb、st
    var weight: YFWeightUnitsType = .kg
    /// 天气 ℃、℉
    var weather: YFTempUnitsType = .centigrade
    
    /// 外部用的公英制
    public var system: YFSystemType {
        get {
            if distance == .m, weight == .kg, weather == .centigrade { return .metric }
            return .imperial
        }
        set {
            if newValue == .metric { distance = .m; weight = .kg; weather = .centigrade }
            if newValue == .imperial { distance = .mile; weight = .lb; weather = .fahrenheit }
        }
    }
    
    var cmd: CE_UnitSettingCmd {
        let cmd = CE_UnitSettingCmd()
        cmd.distance = Int(distance.rawValue)
        cmd.weather = Int(weather.rawValue)
        cmd.weight = Int(weight.rawValue)
        return cmd
    }
}

extension YFUnit {
    func csvContent() -> String {
        let data = [distance.rawValue, weight.rawValue, weather.rawValue]
        let titleItems = ["Unit,Distance", ",Weight", ",Weather"]
        let valueItems: [String] = data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
