//
//  YFNotifyType.swift
//  YFitKit
//
//  Created by Mac on 2021/4/23.
//

import Foundation
import HandyJSON
import YFitSDK

/// 设备Event， 用于设备通知手机的事件

public enum YFNotifyType {
    /// 查找手机
    public enum FindPhone: UInt8 {
        case stop   = 0x00 // 停止
        case start  = 0x01 // 开启
        
        public var name: String {
            switch self {
            case .stop: return "停止"
            case .start: return "开启"
            }
        }
    }
    /// 相机
    public enum Camera: UInt8 {
        case exit   = 0x00 // 退出
        case take   = 0x01 // 拍照
        
        public var name: String {
            switch self {
            case .exit: return "退出"
            case .take: return "拍照"
            }
        }
    }
    
    /// 训练
    public enum Exercise: UInt8 {
        case exit  = 0x04  // 停止
        
        public var name: String {
            switch self {
            case .exit: return "停止"
            }
        }
    }
    
    case findPhone(FindPhone)
    case camera(Camera)
    case exercise(Exercise)
    
    public var name: String {
        switch self {
        case .findPhone(let type): return "查找手机.\(type.name)"
        case .camera(let type): return "相机.\(type.name)"
        case .exercise(let type): return "训练.\(type.name)"

        }
    }
}

extension K6_DataFuncType {
    var isEvent:Bool { K6_DataFuncType.eventCollection.contains(self) }
    static let eventCollection: [K6_DataFuncType] = [DATA_TYPE_FIND_PHONE_OR_DEVICE,
                                                     DATA_TYPE_PHOTOGRAPH_ONOFF,
                                                     DATA_TYPE_APP_SPORT]
}

extension YFNotifyType {
    
    static func parse(_ type: K6_DataFuncType, _ dictData: Dictionary<String, Any>) -> YFNotifyType? {
        switch type {
        case .DATA_TYPE_FIND_PHONE_OR_DEVICE:
            guard let onoff: UInt8 = dictData["onoff"] as? UInt8,
                  let type = FindPhone(rawValue: onoff) else { return nil}
                return .findPhone(type)
        case .DATA_TYPE_PHOTOGRAPH_ONOFF:
            guard let onoff: UInt8 = dictData["takePhoto"] as? UInt8,
                  let type = Camera(rawValue: onoff) else { return nil}
                return .camera(type)
        case .DATA_TYPE_APP_SPORT:
            guard let onoff: UInt8 = dictData["status"] as? UInt8,
                  let type = Exercise(rawValue: onoff) else { return nil}
                return .exercise(type)
        default: return nil
        }
    }
}
