//
//  YFOtaDevice.swift
//  YFitKit
//
//  Created by Mac on 2021/4/22.
//

import Foundation
import HandyJSON
import YFitSDK

/// 设备OTA， 用于固件更新
public class YFOtaDevice {
    /// 信息
    var info: Dictionary<String, Any>?
    /// 状态
    var status: Dictionary<String, Any>?
    
    /// : - 模型
    var infoModel: YFOtaDeviceInfo? {
        YFOtaDeviceInfo.deserialize(from: info)
    }
    var statusModel: YFOtaDeviceStatus? {
        YFOtaDeviceStatus.deserialize(from: status)
    }
}

extension YFOtaDevice {
    func update(forItem item: Dictionary<String, Any>) {
        guard let dataType: Int = item["DataType"] as? Int,
              let data: Dictionary<String, Any> = item["Data"] as? Dictionary<String, Any>,
              let type = K6_DataFuncType(rawValue: dataType) else { return }
        switch type {
        case .DATA_TYPE_DEVINFO:
            self.info = data
        case .DATA_TYPE_OTA_STATUS:
            self.status = data
        default: break
        }
    }
}

extension K6_DataFuncType {
    var isOta:Bool { K6_DataFuncType.otaCollection.contains(self) }
    static let otaCollection: [K6_DataFuncType] = [DATA_TYPE_DEVINFO,
                                                   DATA_TYPE_OTA_STATUS]
}

public class YFOtaDeviceInfo: YFModelBase {
    public private(set) var code_id: Int = 6
    public private(set) var customer_id: Int = 3
    public private(set) var font_id: Int = 0
    public private(set) var hardware_id: Int = 3
    public private(set) var picture_id: Int = 2
}

public class YFOtaDeviceStatus: YFModelBase {
    public private(set) var code_id: Int = 6
    public private(set) var customer_id: Int = 3
    public private(set) var font_id: Int = 0
    public private(set) var hardware_id: Int = 3
    public private(set) var picture_id: Int = 2
}
