//
//  YFExerciseItem.swift
//  YFitKit
//
//  Created by Mac on 2021/4/12.
//

import Foundation
import HandyJSON

/// 运动训练记录
public class YFExerciseItem: YFModelBase {
    /// 日期
    public private(set) var dateStr: String = ""
    /// 运动类型
    public private(set) var sport_type: YFSportType = .null
    /// 开始时间戳
    public private(set) var start_time: TimeInterval = 0
    /// 结束时间戳
    public private(set) var end_time: TimeInterval = 0
    /// 总用时（m）
    public private(set) var total_time: UInt16 = 0
    
    /// 步数
    public private(set) var step: UInt32 = 0
    /// 距离
    public private(set) var distance: UInt16 = 0
    /// 卡路里
    public private(set) var calories: UInt16 = 0
    /// 速度（平均）
    public private(set) var speed: Double = 0
    /// 速度（最快）
    public private(set) var max_speed: Double = 0
    /// 心率（平均）
    public private(set) var heartrate: UInt8 = 0
    /// 心率 （最快）
    public private(set) var max_hr: UInt8 = 0
    /// 心率 （平均）
    public private(set) var aver_hr: UInt8 = 0

    
    func loadDateStr() { dateStr = YFCalendarUtils.dateStr(timeInterval: start_time) }

}

extension YFExerciseItem: Comparable {
    public static func < (lhs: YFExerciseItem, rhs: YFExerciseItem) -> Bool {
        lhs.start_time < rhs.start_time
    }
    
    public static func == (lhs: YFExerciseItem, rhs: YFExerciseItem) -> Bool {
        lhs.start_time == rhs.start_time
    }
}

///: - 数据库
/// 存储
extension Array where Element: YFExerciseItem {
    func save()  { forEach { $0.save()  } }
}

extension YFExerciseItem {
    func save() {  YFRecordExercise.save(with: self) }
}

/// 查询
extension YFExerciseItem {
    
    static func parse(with record: YFRecordExercise) -> YFExerciseItem {
        let model = YFExerciseItem()
        model.dateStr = record.BG_dateStr
        model.sport_type = YFSportType(rawValue: record.BG_sport_type) ?? .null
        model.start_time = record.BG_start_time
        model.end_time = record.BG_end_time
        model.total_time = record.BG_total_time
        
        model.step = record.BG_step
        model.distance = record.BG_distance
        model.calories = record.BG_calories
        model.speed = record.BG_speed
        model.max_speed = record.BG_max_speed
        model.heartrate = record.BG_heartrate
        model.max_hr = record.BG_max_hr
        model.aver_hr = record.BG_aver_hr
       
        return model
    }
    
    static func query(with date: Date) -> [YFExerciseItem] {
        let records = YFRecordExercise.query(with: date)
        return records.map { YFExerciseItem.parse(with: $0) }
    }
}



// MARK: - 一天 运动训练记录
public class YFExercise{
    /// 日期
    public private(set) var dateStr: String = ""
    /// 总运动分钟数
    public private(set) var totalMinutes: Int = 0
    /// 一天的运动锻炼数据
    public private(set) var records: [YFExerciseItem] = []
    
    private init(dateStr: String, totalMinutes: Int, records: [YFExerciseItem]) {
        self.dateStr = dateStr
        self.totalMinutes = totalMinutes
        self.records = records
    }
    
    public static func query(with date: Date) -> YFExercise? {
        let records = YFRecordExercise.query(with: date).map({ YFExerciseItem.parse(with: $0) })
        guard let first = records.first else { return nil}
        var time: Int = 0
        records.forEach({ time += Int($0.total_time) })
        time /= 60
        return YFExercise(dateStr: first.dateStr, totalMinutes: time,  records: records)
    }
    
    /// 查询【fromDate，toDate 】天数据
    public static func query(from fromDate: Date, to toDate: Date) -> [YFExercise] {
        var resultArray = [YFExercise]()
        var date = fromDate
        while date <= toDate {
            if let item = query(with: date) {
                resultArray.append(item)
            } else {
                // resultArray.append(YFTotal())
            }
            if let nextDate = YFCalendarUtils.offsetDay(date, 1) {
                date = nextDate
            } else {
                break;
            }
        }
        return resultArray
    }
}
