//
//  YFWeather.swift
//  Alamofire
//
//  Created by Mac on 2021/11/8.
//

import Foundation
import YFitSDK
import NEUtils

/// 天气 - YFit
enum YFWeatherType: Int, YFEnumtProtocol {
    case sunny = 0           // 晴天
    case cloudy = 1          // 多云
    case cloudyPartly = 2    // 阴天
    case rain = 3            // 雨
    case snow = 4            // 雪
    
    static func parse(_ t: NEWeatherType) ->  YFWeatherType {
        switch t {
        case .fineDay: return .sunny
        case .lightRain, .heavyRain, .moderateRain, .shower, .thunderStorm: return .rain
        case .snow: return .snow
        case .cloudyToFine: return .cloudyPartly
        default: return .cloudy
        }
    }
};

/// 同步天气信息( 6 小时)
public class YFWeather: YFModelBase {
    var time: Double = 0
    var group1: YFWeatherHourGroup = YFWeatherHourGroup()
    var group2: YFWeatherHourGroup = YFWeatherHourGroup()
    var group3: YFWeatherHourGroup = YFWeatherHourGroup()
    
    var cmd: CE_SyncWeatherCmd {
        let cmd = CE_SyncWeatherCmd()
        cmd.time = Int32(truncating: NSNumber(value: time))
        cmd.todyWeather = group1.ce_item
        cmd.tomorrowWeather = group2.ce_item
        cmd.dayAfterTomorrowWeather = group3.ce_item
        return cmd
    }
    
    ///: -  index: 0~3  对应 [0,5] ~ [18~23]
    static func weather(_ index: Int) -> YFWeather? {
        guard let hoursArray = NEWeatherInfo.hourItems else { return nil }
        let dayTime = YFCalendarUtils.dayDate(for: Date()).timeIntervalSince1970
        let hourly_ts = NEWeatherInfo.hourly_ts
        guard let hourInterval = YFCalendarUtils.hourInterval(from: dayTime, to: hourly_ts),
              labs(hourInterval) < 24 else { return nil }
        if index == 0 {
            YFLog.i("dayTime: \(dayTime)")
            YFLog.i("hourly_ts: \(hourly_ts)")
            YFLog.i("hourIntervel: \(hourInterval)")
        }
        
        /// 服务器新获取的数据，hourly_ts 可能大于当前时间一点点，即 offsetHour = -1
        /// 为了避免这种情况天气数据不能实时显示：
        /// hourly_ts 需减去一个小时，hourly数组左复制一组
        let m = YFWeather()
        m.time = hourly_ts
        if NEWeatherInfo.currentHourOffset == -1 {  m.time -= 3600 }
        for i in 0...2 {
            let idx = index * 6 + i * 2;
            var idx1 = idx - hourInterval + 24;
            var idx2 = idx1 + 1;
            idx1 %= 24;
            idx2 %= 24;
            let hour1 = YFWeatherHour(hoursArray[idx1])
            let hour2 = YFWeatherHour(hoursArray[idx2])
            let group = YFWeatherHourGroup(index, hour1, hour2)
            if i==0 { m.group1 = group }
            if i==1 { m.group2 = group }
            if i==2 { m.group3 = group }
        }
        return m
    }
}

public class YFWeatherHourGroup: YFModelBase {
    var hour1: YFWeatherHour = YFWeatherHour()
    var hour2: YFWeatherHour = YFWeatherHour()
    var index: UInt8 = 0
    var ce_item: CE_WeatherItem {
        let cmd = CE_WeatherItem()
        cmd.weather = UInt8(truncating: NSNumber(value: hour1.type.rawValue)) 
        cmd.low_temperature = UInt8(truncating: NSNumber(value: hour1.temp))
        cmd.high_temperature = UInt8(truncating: NSNumber(value: hour2.type.rawValue))
        cmd.pm = UInt16(truncating: NSNumber(value: hour2.temp)) | (UInt16(index) << 8)
        return cmd
    }
    
    convenience init(_ index: Int, _ hour1: YFWeatherHour, _ hour2: YFWeatherHour ) {
        self.init()
        self.hour1 = hour1
        self.hour2 = hour2
        self.index = UInt8(truncating: NSNumber(value: index))
    }
}

public class YFWeatherHour: YFModelBase {
    var type: YFWeatherType = .cloudy
    var temp: Int8 = 0
    
    convenience init(_ m: NEWeatherHourItem) {
        self.init()
        self.type = YFWeatherType.parse(m.type)
        self.temp = m.temperature
    }
}

