//
//  YFUtils.swift
//  YFitKit
//
//  Created by Mac on 2021/1/31.
//

import Foundation
import HandyJSON
import YFitSDK

/// 搜索、连接、配对状态
public enum YFProductStatus: Int, YFEnumtProtocol {
    case none = 0x00    //还没开始搜索
    case powerOff       //蓝牙断开
    case searching      //搜索中
    case connecting     //正在连接中...
    case disconnected   //连接断开
    case connected      //连接成功,开始配对
    case completed      //配对完成,可以正常通信
    
    static func parse(_ status: Int) -> YFProductStatus? {
        YFProductStatus(rawValue: status)
    }
    
    var text: String {
        switch self {
        case .none: return "none"
        case .powerOff: return "powerOff"
        case .searching: return "searching"
        case .connecting: return "connecting"
        case .disconnected: return "disconnected"
        case .connected: return "connected"
        case .completed: return "completed"
        }
    }
    
}

/// 训练运动类型
public enum YFSportType: UInt8, YFEnumtProtocol {
    case null = 0
    case breathe        //呼吸
    case cycling        //骑车或室外骑车
    case cyclingIndoor  //室内骑车
    case runningMachine //跑步机或室内跑步
    case run            //跑步或室外跑步
    case swim           //游泳
    case walk           //走路
    case weight         //举重
    case yoga           //瑜咖
    case badminton      //羽毛球
    case basketball     //篮球
    case skip           //跳绳
    case exercise       //自由锻炼
    case football       //足球
    case climbing       //爬山
    case pingPong       //乒乓球
}

/// 训练运动状态
public enum YFSportStatus: UInt8, YFEnumtProtocol {
    case stop   = 0 //停止
    case start      //开始
    case pause      //暂停
    case play       //继续
    case stopForce  //强制停止
    case syncData   //运动数据同步请求
}

public enum YFCmdSwitchType: UInt8, YFEnumtProtocol {
    case off = 0x00
    case on  = 0x01
    
    var text: String {
        switch self {
        case .off: return "关闭"
        case .on: return "打开"
        }
    }
    
    public var boolValue: Bool {
        switch self {
        case .off: return false
        case .on:  return true
        }
    }
}


extension CE_Cmd {
    
    // 嵌套结构体
    struct AssociatedKeys {
        static var displayKey = "displayKey"
        static var displayNameKey = "displayNameKey"
    }
    
    // Bool 类型
    var display: Bool {
        get {
            return objc_getAssociatedObject(self, &AssociatedKeys.displayKey) as! Bool
        }
        set {
            objc_setAssociatedObject(self, &AssociatedKeys.displayKey, newValue, objc_AssociationPolicy.OBJC_ASSOCIATION_RETAIN_NONATOMIC)
        }
    }
    
    // String 类型
    var displayName: String? {
        get {
            return objc_getAssociatedObject(self, &AssociatedKeys.displayNameKey) as? String
        }
        set {
            objc_setAssociatedObject(self, &AssociatedKeys.displayNameKey, newValue, objc_AssociationPolicy.OBJC_ASSOCIATION_COPY_NONATOMIC)
        }
    }
}


