
//
//  YFCalendarUtils.swift
//  YFitKit
//
//  Created by Shirajo on 2018/8/7.
//  Copyright © 2018年 Shirajo. All rights reserved.
//

import Foundation

class YFCalendarUtils: NSObject  {
    
    // MARK: 常量
    static let kSecondsOneMinutes   = 60;
    static let kSecondsTenMinutes   = 600;
    static let kSecondsOneHour      = 60 * YFCalendarUtils.kSecondsOneMinutes;
    static let kSecondsOneDay       = 24 * YFCalendarUtils.kSecondsOneHour;
    
    static let kShortWeekSymbols: [String] = Calendar.autoupdatingCurrent.shortStandaloneWeekdaySymbols;
    static let kVeryShortWeekdaySymbols: [String] = Calendar.autoupdatingCurrent.veryShortWeekdaySymbols;
    static let kDateComponentAll: Set = [Calendar.Component.year, Calendar.Component.month, Calendar.Component.day,
                                          Calendar.Component.hour, Calendar.Component.minute, Calendar.Component.second,
                                          Calendar.Component.nanosecond, Calendar.Component.weekday];
    static let kDateComponentTime: Set = [Calendar.Component.hour, Calendar.Component.minute,
                                          Calendar.Component.second,Calendar.Component.nanosecond];
    
    static let calendar: Calendar = Calendar(identifier: .gregorian)

    static let timeZoneTimeinterval: TimeInterval = {
        TimeInterval(TimeZone.current.secondsFromGMT())
    } ()
    
    static var nowTimeinterval: TimeInterval { Date().timeIntervalSince1970 }
    
    // MARK: - 提供方便使用的方法
    
    static func date(withHour hourOfDay: Int, minute: Int = 0) -> Date {
        var dateComponents: DateComponents = DateComponents();
        dateComponents.hour = hourOfDay;
        dateComponents.minute = minute;
        return calendar.date(from: dateComponents)!;
    }
    
    static func date(withYear year: Int, month: Int, day: Int,
                     hour: Int = 0, minute: Int = 0, second: Int = 0, nanosecond: Int = 0) -> Date {
        var dateComponents: DateComponents = DateComponents();
        dateComponents.year = year;
        dateComponents.month = month;
        dateComponents.day = day;
        dateComponents.hour = hour;
        dateComponents.minute = minute;
        dateComponents.second = second;
        dateComponents.nanosecond = nanosecond;
        return calendar.date(from: dateComponents)!;
    }
    
    /// 字符串转 Date
    static func date(from dateStr: String, format: String) -> Date {
        let dateFormatter: DateFormatter = DateFormatter();
        dateFormatter.dateFormat = format;
        return dateFormatter.date(from: dateStr)!;
    }
    
    
    /// Component
    static func components(_ components: Set<Calendar.Component>, from date1: Date, to date2: Date) -> DateComponents {
        return calendar.dateComponents(components, from: date1, to: date2)
    }
    
    static func components(ofDate date: Date) -> DateComponents {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components;
    }
    
    static func year(ofDate date: Date) -> Int {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components.year!;
    }
    
    static func month(ofDate date: Date) -> Int {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components.month!;
    }
    
    static func day(ofDate date: Date) -> Int {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components.day!;
    }
    
    static func weekDay(ofDate date: Date) -> Int {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components.weekday!;
    }
    
    static func hour(ofDate date: Date) -> Int {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components.hour!;
    }
    
    static func minute(ofDate date: Date) -> Int {
        let components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        return components.minute!;
    }
    
    /// 清除 日时分秒
    static func monthDate(for date: Date) -> Date {
        var components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        components.day = 1;
        components.hour = 0;
        components.minute = 0;
        components.second = 0;
        components.nanosecond = 0;
        return calendar.date(from: components)!;
    }
    
    /// 清除 时分秒
    static func dayDate(for date: Date) -> Date {
        var components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        components.hour = 0;
        components.minute = 0;
        components.second = 0;
        components.nanosecond = 0;
        return calendar.date(from: components)!;
    }
    
    /// 清除 分秒
    static func hourDate(for date: Date) -> Date {
        var components: DateComponents = calendar.dateComponents(kDateComponentAll, from: date);
        components.minute = 0;
        components.second = 0;
        components.nanosecond = 0;
        return calendar.date(from: components)!;
    }
    
    /// 是否为当天
    static func isToday(_ date: Date) -> Bool {
        return calendar.isDateInToday(date);
    }
    
    /// offsetDay
    static func offsetDay(_ date: Date, _ value: Int) -> Date? {
        return calendar.date(byAdding: .day, value: value, to: date)
    }
}

extension YFCalendarUtils {
    
    static let dateFormatter :DateFormatter = {
        let fm = DateFormatter();
        fm.dateFormat = "yyyy-MM-dd";
        return fm;
    }()
    
    static func dateStr(timeInterval: TimeInterval) -> String {
        dateFormatter.string(from: Date(timeIntervalSince1970: timeInterval))
    }
    
    static func dateStr(date: Date) -> String {
        dateFormatter.string(from: date)
    }
    
    static let datetimeFormatter :DateFormatter = {
        let fm = DateFormatter();
        fm.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        return fm;
    }()
    
    static func datetimeStr(date: Date) -> String {
        datetimeFormatter.string(from: date)
    }
    
    static let timeFormatter :DateFormatter = {
        let fm = DateFormatter();
        fm.dateFormat = "HH:mm"
        return fm;
    }()
    
    static func timeStr(date: Date) -> String {
        timeFormatter.string(from: date)
    }
    
    static func timeStr(timeInterval: TimeInterval) -> String {
        timeFormatter.string(from: Date(timeIntervalSince1970: timeInterval))
    }
    
    static func minutesOffset(from timeStart: TimeInterval, to timeEnd: TimeInterval) -> Int {
        let offset = (timeEnd - timeStart)/60
        return max(0, NSNumber(value: offset).intValue)
    }
    
    static func hourInterval(from timeStart: TimeInterval, to timeEnd: TimeInterval) -> Int? {
        let components = components([.hour], from: Date(timeIntervalSince1970: timeStart), to: Date(timeIntervalSince1970: timeEnd))
        return components.hour
    }
    
    static func dayInterval(from timeStart: TimeInterval, to timeEnd: TimeInterval) -> Int? {
        let components = components([.day], from: Date(timeIntervalSince1970: timeStart), to: Date(timeIntervalSince1970: timeEnd))
        return components.day
    }
    
    static func someDay(from timeStart: TimeInterval, to timeEnd: TimeInterval) -> Bool {
        let components = components([.day], from: Date(timeIntervalSince1970: timeStart), to: Date(timeIntervalSince1970: timeEnd))
        return (components.day == 0)
    }
}
